<div class="wrap upperrank-admin">
    <h1><?php echo esc_html(get_admin_page_title()); ?></h1>

    <div class="upperrank-container">
        <?php if (!$api_key): ?>
            <!-- Step 1: Generate API Key -->
            <div class="upperrank-card">
                <h2>🔑 Step 1: Generate API Key</h2>
                <p>Generate an API key to connect your WordPress site to UpperRank.</p>
                <button type="button" id="generate-key-btn" class="button button-primary">Generate API Key</button>
                <div id="api-key-result" class="hidden">
                    <div class="notice notice-success">
                        <p><strong>API Key Generated Successfully!</strong></p>
                        <div class="api-key-display">
                            <code id="api-key-value"></code>
                            <button type="button" id="copy-key-btn" class="button button-small">Copy</button>
                        </div>
                        <p><em>Copy this API key and save it in your UpperRank dashboard.</em></p>
                    </div>
                </div>
            </div>
        <?php else: ?>
            <!-- Connected State -->
            <div class="upperrank-card">
                <h2>✅ Connected to UpperRank</h2>

                <?php if ($connection): ?>
                    <div class="connection-details">
                        <p><strong>Status:</strong> <span class="status-badge status-<?php echo esc_attr($connection->status); ?>"><?php echo esc_html(ucfirst($connection->status)); ?></span></p>
                        <p><strong>Connected Site:</strong> <?php echo esc_html($connection->site_name); ?></p>
                        <p><strong>Site URL:</strong> <a href="<?php echo esc_url($connection->site_url); ?>" target="_blank"><?php echo esc_html($connection->site_url); ?></a></p>
                        <?php if ($connection->last_sync): ?>
                            <p><strong>Last Sync:</strong> <?php echo esc_html(human_time_diff(strtotime($connection->last_sync), current_time('timestamp'))); ?> ago</p>
                        <?php endif; ?>
                        <p><strong>Connected Since:</strong> <?php echo esc_html(date_i18n(get_option('date_format'), strtotime($connection->created_at))); ?></p>
                    </div>
                <?php endif; ?>

                <div class="connection-info">
                    <h3>Your API Key</h3>
                    <div class="api-key-display">
                        <code><?php echo esc_html(substr($api_key, 0, 20) . '...' . substr($api_key, -10)); ?></code>
                        <button type="button" id="copy-key-btn" class="button button-small" data-key="<?php echo esc_attr($api_key); ?>">Copy Full Key</button>
                        <button type="button" id="regenerate-key-btn" class="button button-secondary">Regenerate Key</button>
                    </div>
                </div>

                <div class="api-endpoints">
                    <h3>API Endpoints</h3>
                    <table class="widefat">
                        <thead>
                            <tr>
                                <th>Endpoint</th>
                                <th>URL</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td>Health Check</td>
                                <td><code><?php echo esc_html(rest_url('upperrank/v1/health')); ?></code></td>
                            </tr>
                            <tr>
                                <td>Create/Update Post</td>
                                <td><code><?php echo esc_html(rest_url('upperrank/v1/post')); ?></code></td>
                            </tr>
                            <tr>
                                <td>Delete Post</td>
                                <td><code><?php echo esc_html(rest_url('upperrank/v1/post/{id}')); ?></code></td>
                            </tr>
                        </tbody>
                    </table>
                </div>

                <div class="actions">
                    <button type="button" id="test-connection-btn" class="button">Test Connection</button>
                    <button type="button" id="disconnect-btn" class="button button-link-delete">Disconnect</button>
                </div>

                <div class="settings-section">
                    <h3>⚙️ Publishing Settings</h3>
                    <p>Configure default settings for posts published from UpperRank.</p>
                    <form id="upperrank-settings-form">
                        <table class="form-table">
                            <tr>
                                <th scope="row">
                                    <label for="default-category">Default Category</label>
                                </th>
                                <td>
                                    <select name="default_category" id="default-category" class="regular-text">
                                        <option value="">-- Select Category --</option>
                                        <?php foreach ($categories as $category): ?>
                                            <option value="<?php echo esc_attr($category->term_id); ?>" <?php selected($default_category, $category->term_id); ?>>
                                                <?php echo esc_html($category->name); ?>
                                            </option>
                                        <?php endforeach; ?>
                                    </select>
                                    <p class="description">Posts from UpperRank will be assigned to this category by default.</p>
                                    <p class="description">
                                        <a href="<?php echo esc_url(admin_url('edit-tags.php?taxonomy=category')); ?>" target="_blank">Manage Categories</a>
                                    </p>
                                </td>
                            </tr>
                            <tr>
                                <th scope="row">
                                    <label for="default-author">Default Author</label>
                                </th>
                                <td>
                                    <select name="default_author" id="default-author" class="regular-text">
                                        <?php foreach ($authors as $author): ?>
                                            <option value="<?php echo esc_attr($author->ID); ?>" <?php selected($default_author, $author->ID); ?>>
                                                <?php echo esc_html($author->display_name); ?> (<?php echo esc_html($author->user_login); ?>)
                                            </option>
                                        <?php endforeach; ?>
                                    </select>
                                    <p class="description">Posts from UpperRank will be published under this author.</p>
                                </td>
                            </tr>
                        </table>
                        <p class="submit">
                            <button type="submit" class="button button-primary">Save Settings</button>
                        </p>
                    </form>
                </div>
            </div>
        <?php endif; ?>

        <div class="upperrank-card">
            <h2>📚 Documentation</h2>
            <div class="documentation">
                <h3>How to Connect</h3>
                <ol>
                    <li>Generate an API key in the UpperRank WordPress plugin (this page)</li>
                    <li>Go to your UpperRank dashboard → Integrations → WordPress</li>
                    <li>Enter your WordPress site URL and the API key</li>
                    <li>Click "Connect" to establish the connection</li>
                    <li>Start publishing and scheduling posts directly from UpperRank!</li>
                </ol>

                <h3>Features</h3>
                <ul>
                    <li>✅ Create and publish posts directly from UpperRank</li>
                    <li>✅ Schedule posts for future publication</li>
                    <li>✅ Update existing posts</li>
                    <li>✅ Automatically upload featured images</li>
                    <li>✅ Assign categories and tags</li>
                    <li>✅ Secure API key authentication</li>
                    <li>✅ Real-time connection health monitoring</li>
                </ul>

                <h3>API Authentication</h3>
                <p>All API requests require the API key to be sent in the Authorization header:</p>
                <pre><code>Authorization: Bearer YOUR_API_KEY</code></pre>
            </div>
        </div>

        <div id="notification-area"></div>
    </div>
</div>
